/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include "project.h"

void SPIWrite(uint32_t Data, uint32_t Slave);
void InitSPI(uint32_t Width);

int main(void) {
	CyGlobalIntEnable; /* Enable global interrupts. */

	/* Place your initialization/startup code here (e.g. MyInst_Start()) */
	InitSPI(6);
	SPIM_Start();

	for(;;) {
		/* Place your application code here. */
		InitSPI(4);
		SPIWrite(0x5555, SPIM_SPI_SLAVE_SELECT0);
		InitSPI(8);
		SPIWrite(0x5555, SPIM_SPI_SLAVE_SELECT1);
		InitSPI(12);
		SPIWrite(0x5555, SPIM_SPI_SLAVE_SELECT2);
		InitSPI(16);
		SPIWrite(0x5555, SPIM_SPI_SLAVE_SELECT3);
	}
}

void SPIWrite(uint32_t Data, uint32_t Slave) {
	while(SPIM_SpiIsBusBusy());
	SPIM_SpiSetActiveSlaveSelect(Slave);
	SPIM_SpiUartWriteTxData(Data);
}

void InitSPI(uint32_t Width) {
	SPIM_SPI_INIT_STRUCT SPIM_configSpi = {
		SPIM_SPI_MASTER,
		SPIM_SPI_MODE_MOTOROLA,
		SPIM_SPI_SCLK_CPHA0_CPOL0,
		SPIM_SPI_OVS_FACTOR,
		SPIM_SPI_MEDIAN_FILTER_ENABLE,
		SPIM_SPI_LATE_MISO_SAMPLE_ENABLE,
		SPIM_SPI_WAKE_ENABLE,
		Width,
		Width,
		SPIM_SPI_BITS_ORDER,
		SPIM_SPI_TRANSFER_SEPARATED,
		0u,
		NULL,
		0u,
		NULL,
		(uint32) SPIM_SCB_IRQ_INTERNAL,
		SPIM_SPI_INTR_RX_MASK,
		SPIM_SPI_RX_TRIGGER_LEVEL,
		SPIM_SPI_INTR_TX_MASK,
		SPIM_SPI_TX_TRIGGER_LEVEL,
		(uint8) SPIM_SPI_BYTE_MODE_ENABLE,
		(uint8) SPIM_SPI_FREE_RUN_SCLK_ENABLE,
		(uint8) SPIM_SPI_SS_POLARITY
	};

	while(SPIM_SpiIsBusBusy());
	SPIM_Stop();
	SPIM_SpiInit(&SPIM_configSpi);
	SPIM_Enable();
}

/* [] END OF FILE */
